import { ModelType } from "./types";

export const ADOBE_STOCK_CATEGORIES: Record<string, number> = {
    "Animals": 1,
    "Buildings and Architecture": 2,
    "Business": 3,
    "Drinks": 4,
    "The Environment": 5,
    "States of Mind": 6,
    "Food": 7,
    "Graphic Resources": 8,
    "Hobbies and Leisure": 9,
    "Industry": 10,
    "Landscapes": 11,
    "Lifestyle": 12,
    "People": 13,
    "Plants and Flowers": 14,
    "Culture and Religion": 15,
    "Science": 16,
    "Social Issues": 17,
    "Sports": 18,
    "Technology": 19,
    "Transport": 20,
    "Travel": 21
};

export const MODELS = [
    // Thinking Models
    { id: ModelType.PRO, category: 'thinking', name: 'Gemini 3.0 Pro', tag: 'NEW', tagColor: 'bg-purple-100 dark:bg-purple-900/30 text-purple-600 dark:text-purple-400 border-purple-200 dark:border-purple-500/30', speed: 3, quality: 5, cost: 'High', desc: 'Next-generation reasoning and coding' },
    { id: ModelType.FLASH_3_0, category: 'thinking', name: 'Gemini 3.0 Flash', tag: 'PREVIEW', tagColor: 'bg-cyan-100 dark:bg-cyan-900/30 text-cyan-600 dark:text-cyan-400 border-cyan-200 dark:border-cyan-500/30', speed: 5, quality: 5, cost: 'Low', desc: 'Next-gen fast reasoning model' },
    { id: ModelType.PRO_2_5, category: 'thinking', name: 'Gemini 2.5 Pro', tag: 'POWERFUL', tagColor: 'bg-blue-100 dark:bg-blue-900/30 text-blue-600 dark:text-blue-400 border-blue-200 dark:border-blue-500/30', speed: 3, quality: 5, cost: 'High', desc: 'Top-tier reasoning for complex problems' },
    { id: ModelType.FLASH, category: 'thinking', name: 'Gemini 2.5 Flash', tag: 'FAST', tagColor: 'bg-amber-100 dark:bg-amber-900/30 text-amber-600 dark:text-amber-400 border-amber-200 dark:border-amber-500/30', speed: 5, quality: 5, cost: 'Low', desc: 'Best balance of speed and intelligence' },
    { id: ModelType.FLASH_LITE, category: 'thinking', name: 'Gemini 2.5 Flash Lite', tag: 'LITE', tagColor: 'bg-green-100 dark:bg-green-900/30 text-green-600 dark:text-green-400 border-green-200 dark:border-green-500/30', speed: 5, quality: 4, cost: 'Very Low', desc: 'Extremely fast and cost-effective' },
    { id: ModelType.PRO_1_5, category: 'thinking', name: 'Gemini 1.5 Pro', tag: 'LATEST', tagColor: 'bg-indigo-100 dark:bg-indigo-900/30 text-indigo-600 dark:text-indigo-400 border-indigo-200 dark:border-indigo-500/30', speed: 4, quality: 5, cost: 'Medium', desc: 'Latest 1.5 Pro generation' },

    // Creative Models
    { id: ModelType.IMAGEN_ULTRA, category: 'creative', name: 'Imagen 4 Ultra', tag: 'BEST', tagColor: 'bg-purple-100 dark:bg-purple-900/30 text-purple-600 dark:text-purple-400 border-purple-200 dark:border-purple-500/30', speed: 2, quality: 5, cost: 'High', desc: 'Highest fidelity and detail' },
    { id: ModelType.IMAGEN_FAST, category: 'creative', name: 'Imagen 4 Fast', tag: 'FAST', tagColor: 'bg-green-100 dark:bg-green-900/30 text-green-600 dark:text-green-400 border-green-200 dark:border-green-500/30', speed: 5, quality: 4, cost: 'Low', desc: 'Rapid image generation for iteration' },
    { id: ModelType.IMAGEN_STD, category: 'creative', name: 'Imagen 4 Std', tag: 'STANDARD', tagColor: 'bg-blue-100 dark:bg-blue-900/30 text-blue-600 dark:text-blue-400 border-blue-200 dark:border-blue-500/30', speed: 3, quality: 5, cost: 'Medium', desc: 'High quality photorealistic generation' },
    { id: ModelType.PRO_IMAGE_3_0, category: 'creative', name: 'Gemini 3 Pro Image', tag: 'NEW', tagColor: 'bg-indigo-100 dark:bg-indigo-900/30 text-indigo-600 dark:text-indigo-400 border-indigo-200 dark:border-indigo-500/30', speed: 3, quality: 5, cost: 'High', desc: 'Next-gen multimodal image generation' },
    { id: ModelType.FLASH_IMAGE_2_5, category: 'creative', name: 'Gemini 2.5 Flash Image', tag: 'FAST', tagColor: 'bg-amber-100 dark:bg-amber-900/30 text-amber-600 dark:text-amber-400 border-amber-200 dark:border-amber-500/30', speed: 5, quality: 4, cost: 'Low', desc: 'Fast multimodal image generation' },

    // Video Models
    { id: ModelType.VEO_HQ, category: 'video', name: 'Veo 3.1', tag: 'HQ', tagColor: 'bg-pink-100 dark:bg-pink-900/30 text-pink-600 dark:text-pink-400 border-pink-200 dark:border-pink-500/30', speed: 2, quality: 5, cost: 'High', desc: 'High quality video generation' },
    { id: ModelType.VEO, category: 'video', name: 'Veo 3.1 Fast', tag: 'FAST', tagColor: 'bg-rose-100 dark:bg-rose-900/30 text-rose-600 dark:text-rose-400 border-rose-200 dark:border-rose-500/30', speed: 4, quality: 4, cost: 'Medium', desc: 'Faster video generation' },
    { id: ModelType.VEO_3_0, category: 'video', name: 'Veo 3.0', tag: 'LEGACY', tagColor: 'bg-slate-100 dark:bg-slate-800 text-slate-600 dark:text-slate-400 border-slate-200 dark:border-slate-700', speed: 3, quality: 4, cost: 'Medium', desc: 'Previous generation video model' },
    { id: ModelType.VEO_2_0, category: 'video', name: 'Veo 2.0', tag: 'LEGACY', tagColor: 'bg-slate-100 dark:bg-slate-800 text-slate-600 dark:text-slate-400 border-slate-200 dark:border-slate-700', speed: 3, quality: 3, cost: 'Low', desc: 'Legacy video model' },
];

export const SETTINGS_TO_MODEL_TYPE: Record<string, string> = {
    // Thinking
    'flash_lite': ModelType.FLASH_LITE,
    'flash': ModelType.FLASH,
    'gemini_3_0_flash': ModelType.FLASH_3_0,
    'pro': ModelType.PRO,
    'pro_2_5': ModelType.PRO_2_5,
    'gemini_1_5_pro': ModelType.PRO_1_5,

    // Missing keys from defaults
    'flash_lite_2_5': ModelType.FLASH_LITE,
    'flash_2_5': ModelType.FLASH,

    'pro_3_0': ModelType.PRO,

    // Creative
    'imagen_fast': ModelType.IMAGEN_FAST,
    'imagen_std': ModelType.IMAGEN_STD,
    'imagen_ultra': ModelType.IMAGEN_ULTRA,

    'imagen_4_fast': ModelType.IMAGEN_FAST,
    'imagen_4_std': ModelType.IMAGEN_STD,
    'imagen_4_ultra': ModelType.IMAGEN_ULTRA,

    'flash_image_2_5': ModelType.FLASH_IMAGE_2_5,
    'gemini_2_5_flash_image': ModelType.FLASH_IMAGE_2_5,

    'pro_image_3_0': ModelType.PRO_IMAGE_3_0,
    'gemini_3_pro_image': ModelType.PRO_IMAGE_3_0,

    // Video
    'veo': ModelType.VEO,
    'veo_3_1_fast': ModelType.VEO,

    'veo_hq': ModelType.VEO_HQ,
    'veo_3_1': ModelType.VEO_HQ,

    'veo_3_0': ModelType.VEO_3_0,
    'veo_2_0': ModelType.VEO_2_0,
};

// Reverse mapping for Admin Dashboard (using canonical keys that match server.js)
export const MODEL_TYPE_TO_SETTINGS: Record<string, string> = {
    // Thinking
    [ModelType.FLASH_LITE]: 'flash_lite_2_5',
    [ModelType.FLASH]: 'flash_2_5',
    [ModelType.FLASH_3_0]: 'gemini_3_0_flash',
    [ModelType.PRO]: 'pro_3_0',
    [ModelType.PRO_2_5]: 'pro_2_5',
    [ModelType.PRO_1_5]: 'gemini_1_5_pro',

    // Creative
    [ModelType.IMAGEN_FAST]: 'imagen_fast',
    [ModelType.IMAGEN_STD]: 'imagen_std',
    [ModelType.IMAGEN_ULTRA]: 'imagen_ultra',
    [ModelType.FLASH_IMAGE_2_5]: 'gemini_2_5_flash_image',
    [ModelType.PRO_IMAGE_3_0]: 'gemini_3_pro_image',

    // Video
    [ModelType.VEO]: 'veo_3_1_fast',
    [ModelType.VEO_HQ]: 'veo_3_1',
    [ModelType.VEO_3_0]: 'veo_3_0',
    [ModelType.VEO_2_0]: 'veo_2_0',
};
