
import React from 'react';
import { AlertTriangle } from 'lucide-react';

interface RateLimitPopupProps {
    isOpen: boolean;
    onClose: () => void;
}

export const RateLimitPopup: React.FC<RateLimitPopupProps> = ({ isOpen, onClose }) => {
    if (!isOpen) return null;

    return (
        <div className="fixed inset-0 z-[60] flex items-center justify-center bg-black/60 backdrop-blur-sm animate-fade-in p-4">
            <div className="bg-white dark:bg-slate-900 border border-red-500/30 rounded-2xl p-6 max-w-md w-full shadow-2xl transform scale-100 animate-in fade-in zoom-in duration-200">
                <div className="flex items-center gap-4 mb-4 text-red-600 dark:text-red-500">
                    <div className="p-3 bg-red-100 dark:bg-red-900/20 rounded-full">
                        <AlertTriangle size={32} />
                    </div>
                    <h3 className="text-xl font-bold">System Overloaded</h3>
                </div>

                <p className="text-slate-600 dark:text-slate-300 mb-6 leading-relaxed">
                    All available API keys and models are currently rate limited or exhausted.
                    <br /><br />
                    Please add a new API key in Settings, (Enable Api keys or Models), or wait on reset time for your quota to reset.
                </p>

                <div className="flex justify-end gap-3">
                    <button
                        onClick={onClose}
                        className="px-4 py-2 text-slate-500 hover:text-slate-700 dark:text-slate-400 dark:hover:text-slate-200 font-bold transition"
                    >
                        Close
                    </button>
                    <button
                        onClick={() => {
                            onClose();
                            window.dispatchEvent(new CustomEvent('sf_navigate', { detail: 'settings_api' }));
                        }}
                        className="px-5 py-2 bg-red-600 hover:bg-red-700 text-white rounded-xl font-bold transition shadow-lg shadow-red-500/20"
                    >
                        Manage Keys
                    </button>
                </div>
            </div>
        </div>
    );
};
