const mysql = require('mysql2/promise');

async function cleanupOrphanedRecords() {
    const connection = await mysql.createConnection({
        host: 'localhost',
        user: 'root',
        password: '',
        database: 'stockforge'
    });

    try {
        console.log('=== Cleaning up orphaned records ===\n');

        // First, count how many will be deleted
        const [countRows] = await connection.query(`
            SELECT COUNT(*) as count FROM api_key_usage WHERE user_uid IS NULL
        `);

        const orphanedCount = countRows[0].count;
        console.log(`Found ${orphanedCount} orphaned records (no user_uid)`);

        if (orphanedCount > 0) {
            console.log('Deleting orphaned records...');

            const [result] = await connection.query(`
                DELETE FROM api_key_usage WHERE user_uid IS NULL
            `);

            console.log(`✅ Deleted ${result.affectedRows} orphaned records`);
        } else {
            console.log('No orphaned records to clean up!');
        }

        // Show remaining records
        const [remaining] = await connection.query(`
            SELECT COUNT(*) as count FROM api_key_usage
        `);
        console.log(`\nRemaining records in api_key_usage: ${remaining[0].count}`);

    } catch (error) {
        console.error('Error:', error);
    } finally {
        await connection.end();
    }
}

cleanupOrphanedRecords();
