
import db from './database/db.js';

async function describeTable(table) {
    try {
        const [rows] = await db.query(`DESCRIBE ${table}`);
        console.log(`\n--- SCHEMA: ${table} ---`);
        console.table(rows);
    } catch (e) {
        console.error(e);
    }
}

async function run() {
    await describeTable('assets');
    await describeTable('users');
    process.exit();
}

run();
