const mysql = require('mysql2/promise');
require('dotenv').config();

async function checkVariables() {
    try {
        const db = await mysql.createPool({
            host: process.env.DB_HOST || 'localhost',
            user: process.env.DB_USER || 'root',
            password: process.env.DB_PASSWORD || '',
            database: process.env.DB_NAME || 'stockforge'
        });

        const [rows] = await db.query("SHOW VARIABLES LIKE 'max_allowed_packet'");
        console.log("Max Allowed Packet:", rows);

    } catch (e) {
        console.error("Error:", e);
    }
    process.exit();
}
checkVariables();
