const mysql = require('mysql2/promise');

async function checkFlashCalls() {
    const connection = await mysql.createConnection({
        host: 'localhost',
        user: 'root',
        password: '',
        database: 'stockforge'
    });

    try {
        const today = new Date().toISOString().split('T')[0];

        console.log('=== Checking gemini-2.5-flash calls ===\n');

        const [rows] = await connection.query(`
            SELECT 
                usage_date,
                user_uid,
                api_calls,
                model_id
            FROM api_key_usage
            WHERE model_id = 'gemini-2.5-flash'
            ORDER BY usage_date DESC
            LIMIT 20
        `);

        rows.forEach(row => {
            const isToday = row.usage_date.toISOString().split('T')[0] === today;
            console.log(`Date: ${row.usage_date.toISOString().split('T')[0]} ${isToday ? '(TODAY)' : ''}`);
            console.log(`  User UID: ${row.user_uid || '(NULL - PROBLEM!)'}`);
            console.log(`  Calls: ${row.api_calls}`);
            console.log('');
        });

    } catch (error) {
        console.error('Error:', error);
    } finally {
        await connection.end();
    }
}

checkFlashCalls();
