
const mysql = require('mysql2/promise');
const dotenv = require('dotenv');

dotenv.config();

const getLocalYMD = () => {
    const now = new Date();
    const year = now.getFullYear();
    const month = String(now.getMonth() + 1).padStart(2, '0');
    const day = String(now.getDate()).padStart(2, '0');
    return `${year}-${month}-${day}`;
};

async function checkDb() {
    try {
        console.log("Checking DB Value...");
        const db = await mysql.createPool({
            host: process.env.DB_HOST || 'localhost',
            user: process.env.DB_USER || 'root',
            password: process.env.DB_PASSWORD || '',
            database: process.env.DB_NAME || 'stockforge',
            connectionLimit: 1
        });

        const [rows] = await db.query("SELECT * FROM users WHERE role = 'admin' LIMIT 1");
        const user = rows[0];
        let stats = typeof user.usage_stats === 'string' ? JSON.parse(user.usage_stats) : user.usage_stats;

        console.log("Daily Stats (DB):", JSON.stringify(stats.daily));
        console.log("Local Date:", getLocalYMD());

    } catch (e) {
        console.error("Error:", e);
    } finally {
        process.exit();
    }
}

checkDb();
