const mysql = require('mysql2/promise');
require('dotenv').config();

async function check() {
    try {
        const db = await mysql.createPool({
            host: process.env.DB_HOST || 'localhost',
            user: process.env.DB_USER || 'root',
            password: process.env.DB_PASSWORD || '',
            database: process.env.DB_NAME || 'stockforge'
        });

        console.log("Connected to DB");
        const [tables] = await db.query("SHOW TABLES");
        console.log("Tables:", tables);

        const [columns] = await db.query("DESCRIBE assets");
        console.log("Assets Columns:", columns);
    } catch (e) {
        console.error("Error:", e);
    }
    process.exit();
}
check();
