const mysql = require('mysql2/promise');
require('dotenv').config();

async function checkTable() {
    const db = await mysql.createPool({
        host: process.env.DB_HOST || 'localhost',
        user: process.env.DB_USER || 'root',
        password: process.env.DB_PASSWORD || '',
        database: process.env.DB_NAME || 'stockforge'
    });

    const [columns] = await db.query("SHOW COLUMNS FROM assets");
    console.log("assets table columns:");
    columns.forEach(col => {
        console.log(`- ${col.Field} (${col.Type})`);
    });

    process.exit();
}

checkTable();
