const mysql = require('mysql2/promise');
require('dotenv').config();

async function addColumn() {
    const db = await mysql.createPool({
        host: process.env.DB_HOST || 'localhost',
        user: process.env.DB_USER || 'root',
        password: process.env.DB_PASSWORD || '',
        database: process.env.DB_NAME || 'stockforge'
    });

    try {
        console.log("Adding model_id column to api_key_usage table...");

        await db.query(`
            ALTER TABLE api_key_usage 
            ADD COLUMN model_id VARCHAR(100) DEFAULT 'unknown'
        `);

        console.log("✅ Column added successfully!");

        // Verify
        const [columns] = await db.query("SHOW COLUMNS FROM api_key_usage");
        console.log("\nUpdated table structure:");
        columns.forEach(col => {
            console.log(`- ${col.Field} (${col.Type})`);
        });

    } catch (e) {
        console.error("Error:", e.message);
    }

    process.exit();
}

addColumn();
